import pandas as pd  
from sklearn.model_selection import train_test_split  
from sklearn.preprocessing import LabelEncoder  
from sklearn.linear_model import LogisticRegression  
from sklearn.metrics import confusion_matrix, accuracy_score
import pickle  
from decision_company import read_csv_file, encoder_instance, encode_column, fetch_column, divide_dataset, create_LR_instance, classifier_training, classifier_predictions, calculate_conf_mat, calc_acc

# Load the dataset    
credit_customers = read_csv_file("credit_customers.csv")     
  
# Initialize a label encoder  
le = encoder_instance()  
  
# Convert categorical features to numerical values    
credit_customers['credit_history'] = encode_column(le, fetch_column(credit_customers, 'credit_history'))  
credit_customers['employment'] = encode_column(le, fetch_column(credit_customers, 'employment'))  
credit_customers['class'] = encode_column(le, fetch_column(credit_customers, 'class'))  
  
# Select features and target    
X = credit_customers[['credit_history', 'employment', 'age', 'credit_amount']]    
y = fetch_column(credit_customers, 'class')  
  
# Split the dataset into training and testing sets    
X_train, X_test, y_train, y_test = divide_dataset(X, y, test_size=0.2, random_state=42)  
  
# Initialize and train a logistic regression classifier    
clf = create_LR_instance()  
clf = classifier_training(clf, X_train, y_train)  
  
# Make predictions on the testing set    
y_pred = classifier_predictions(clf, X_test)  
  
# Calculate the confusion matrix and accuracy    
cm = calculate_conf_mat(y_test, y_pred)  
acc = calc_acc(y_test, y_pred)  
  
print("Confusion Matrix:\n", cm)  
pickle.dump(cm,open("./ref_result/Confusion_Matrix.pkl","wb"))
print("Accuracy:", acc) 
pickle.dump(acc,open("./ref_result/Accuracy.pkl","wb"))